﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class DeleteAnswerValidator : AbstractValidator<DeleteAnswerCommand>
    {
        public DeleteAnswerValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => new AnswerInQuestionWithUidExistsDto(x.QuestionUid, x.AnswerUid)).SetValidator(new AnswerInQuestionWithUidExists(unitOfWork));
            RuleFor(x => x.AnswerUid).SetValidator(new StudentIsOwnerOfAnswer(unitOfWork, currentUser));
            RuleFor(x => x.AnswerUid).SetValidator(new AnswerIsNotAlreadyMarkedAsCorrect(unitOfWork));
        }
    }
}
