﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class DeleteAnswerResponseCommand : ICommand<Guid>
    {
        public DeleteAnswerResponseCommand(Guid questionUid, Guid answerUid, Guid answerResponseUid)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
            AnswerResponseUid = answerResponseUid;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
        public Guid AnswerResponseUid { get; }
    }

    public class DeleteAnswerResponseHandler : ICommandHandler<DeleteAnswerResponseCommand, Guid>
    {
        public DeleteAnswerResponseHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<Guid> Handle(DeleteAnswerResponseCommand request, CancellationToken cancellationToken)
        {
            var answerResponse = await UnitOfWork.AnswerResponses.GetByUidAsync(request.AnswerResponseUid);

            UnitOfWork.AnswerResponses.Delete(answerResponse);

            await UnitOfWork.SaveAsync();

            return answerResponse.Uid;
        }
    }
}
