﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class DeleteAnswerResponseValidator : AbstractValidator<DeleteAnswerResponseCommand>
    {
        public DeleteAnswerResponseValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => new AnswerInQuestionWithUidExistsDto(x.QuestionUid, x.AnswerUid)).SetValidator(new AnswerInQuestionWithUidExists(unitOfWork));
            RuleFor(x => x.AnswerResponseUid).SetValidator(new StudentIsOwnerOfAnswerResponse(unitOfWork, currentUser));
        }
    }
}
