﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public abstract class Repository<T> : IRepository<T> where T : BaseEntity
    {
        public Repository(ApplicationDbContext dbContext)
        {
            DbContext = dbContext;
            DbSet = DbContext.Set<T>();
        }

        protected ApplicationDbContext DbContext { get; }
        protected DbSet<T> DbSet { get; }

        public IQueryable<T> All()
        {
            return DbSet.AsQueryable();
        }

        public async Task<T> GetByIdAsync(int id)
        {
            return await All().FirstOrDefaultAsync(f => f.Id == id);
        }

        public void Add(T entity)
        {
            DbSet.Add(entity);
        }

        public async Task<T> GetByUidAsync(Guid uid)
        {
            return await All().FirstOrDefaultAsync(f => f.Uid == uid);
        }

        public void Delete(T entity)
        {
            DbSet.Remove(entity);
        }
    }
}
