import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/core/services';
import { ButtonType } from '../button/button.models';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss']
})
export class HeaderComponent implements OnInit {
  ButtonType = ButtonType;

  public studentCheckedNotifications = false;

  constructor(public auth: AuthService, private router: Router) {}

  ngOnInit(): void {}

  logout(): void {
    this.auth.logout();
  }

  askQuestion(): void {
    this.router.navigateByUrl('questioning/ask');
  }

  navigateFromLogo(): void {
    if (this.auth.isStudent()) {
      this.router.navigateByUrl('questioning/preview');
    }
    if (this.auth.isModerator()) {
      this.router.navigateByUrl('moderating/categories');
    }
  }

  goToQuestion(questionUid: string): void {
    this.router.navigateByUrl(`questioning/${questionUid}`);
  }

  studentCheckedNotificationsClick(): void {
    if (!this.studentCheckedNotifications) {
      this.auth.studentCheckedNotifications().subscribe();
    }
    this.studentCheckedNotifications = true;
  }
}
