﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class NotifyStudentHisAnswerIsMarkedCorrect : IEventHandler<AnswerMarkedAsCorrectEvent>
    {
        public NotifyStudentHisAnswerIsMarkedCorrect(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(AnswerMarkedAsCorrectEvent notification, CancellationToken cancellationToken)
        {
            var student = await UnitOfWork.Students.GetByIdAsync(notification.StudentFk);
            var question = await UnitOfWork.Questions.GetByUidAsync(notification.QuestionUid);

            if (student == null)
            {
                return;
            }

            if (question == null)
            {
                return;
            }

            var studentNotification = new StudentNotification()
            {
                StudentFk = student.Id,
                QuestionUid = notification.QuestionUid,
                Text = $"Your answer has been marked as correct on question {question.Title}"
            };

            UnitOfWork.StudentNotifications.Add(studentNotification);
            await UnitOfWork.SaveAsync();
        }
    }
}
