﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class MarkAnswerCorrectCommand : ICommand<Guid>
    {
        public MarkAnswerCorrectCommand(Guid questionUid, Guid answerUid)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
    }

    public class MarkAnswerCorrectHandler : ICommandHandler<MarkAnswerCorrectCommand, Guid>
    {
        public MarkAnswerCorrectHandler(IUnitOfWork unitOfWork, IEventService eventService)
        {
            UnitOfWork = unitOfWork;
            EventService = eventService;
        }

        public IUnitOfWork UnitOfWork { get; }
        public IEventService EventService { get; }

        public async Task<Guid> Handle(MarkAnswerCorrectCommand request, CancellationToken cancellationToken)
        {
            var answer = await UnitOfWork.Answers.GetByUidAsync(request.AnswerUid);
            answer.CorrectAnswer = true;

            await UnitOfWork.SaveAsync();

            EventService.Enqueue(new AnswerMarkedAsCorrectEvent(request.QuestionUid, request.AnswerUid, answer.StudentFk));

            return answer.Uid;
        }
    }
}
