﻿using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;
using System;

namespace FinkiChattery.Persistence.Configurations
{
    public class StudentConfig : BaseConfig<Student>
    {
        public StudentConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<Student> builder)
        {
            base.Configure(builder);

            builder.ToTable("Student", Schema);

            builder.Property(x => x.ApplicationUserFk).HasColumnName(@"ApplicationUserFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.IndexNumber).HasColumnName(@"IndexNumber").HasColumnType("nvarchar").IsRequired().HasMaxLength(50);
            builder.Property(x => x.Reputation).HasColumnName(@"Reputation").HasColumnType("bigint").IsRequired().HasDefaultValue(0);
            builder.Property(x => x.ReportReputation).HasColumnName(@"ReportReputation").HasColumnType("bigint").IsRequired().HasDefaultValue(0);
            builder.Property(x => x.ImageUrl).HasColumnName(@"ImageUrl").HasColumnType("nvarchar").IsRequired().HasMaxLength(1000);
            builder.Property(x => x.LastCheckedNotifications).HasColumnName(@"LastCheckedNotifications").HasColumnType("smalldatetime").IsRequired().HasConversion(v => v, v => DateTime.SpecifyKind(v, DateTimeKind.Utc));

            builder.HasOne(x => x.ApplicationUser).WithOne().HasForeignKey<Student>(x => x.ApplicationUserFk).OnDelete(DeleteBehavior.Restrict);
        }
    }
}
