﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Commands.Notifications;
using FinkiChattery.Common.Mediator.Interfaces;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/[controller]/")]
    [ApiController]
    public class StudentsController : ControllerBase
    {
        public StudentsController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpPost("checked-notifications")]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> AnswerQuestion()
        {
            await MediatorService.SendAsync(new StudentCheckedNotificationsCommand());
            return Ok();
        }
    }
}
