﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class StudentNotificationRepo : Repository<StudentNotification>, IStudentNotificationRepo
    {
        public StudentNotificationRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<List<StudentNotification>> GetStudentNotificationsForStudent(long studentFk)
        {
            return await DbSet.Where(x => x.StudentFk == studentFk).ToListAsync();
        }
    }
}
