import { Component, OnInit } from '@angular/core';
import { AuthService } from 'src/app/core/services';
import { ButtonType } from '../button/button.models';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss']
})
export class HeaderComponent implements OnInit {
  ButtonType = ButtonType;
  loggedIn = false;

  constructor(private auth: AuthService) {}

  ngOnInit(): void {
    this.auth.isLoggedIn().subscribe((loggedIn) => (this.loggedIn = loggedIn));
  }

  logout(): void {
    this.auth.logout();
  }
}
