import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef } from '@angular/material/dialog';

import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-respond-to-answer-dialog',
  templateUrl: './respond-to-answer-dialog.component.html',
  styleUrls: ['./respond-to-answer-dialog.component.scss']
})
export class RespondToAnswerDialogComponent implements OnInit {
  public ButtonType = ButtonType;
  public textField = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public formGroup: FormGroup;
  public questionUid!: string;
  public answerUid!: string;

  constructor(public dialogRef: MatDialogRef<RespondToAnswerDialogComponent>, private questionFacade: QuestionFacadeService) {
    this.formGroup = new FormGroup({
      text: this.textField
    });
  }

  ngOnInit(): void {}

  submit(): void {
    this.questionFacade.respondToAnswer(this.answerUid, this.questionUid, this.textField.value);
    this.dialogRef.close();
  }
}
