﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class RespondToAnswerCommand : ICommand<AnswerResponseQuestionStateDto>
    {
        public RespondToAnswerCommand(Guid questionUid, Guid answerUid, string text)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
            Text = text;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
        public string Text { get; }
    }

    public class RespondToAnswerHandler : ICommandHandler<RespondToAnswerCommand, AnswerResponseQuestionStateDto>
    {
        public RespondToAnswerHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<AnswerResponseQuestionStateDto> Handle(RespondToAnswerCommand request, CancellationToken cancellationToken)
        {
            var answer = await UnitOfWork.Answers.GetByUidAsync(request.AnswerUid);
            var student = await UnitOfWork.Students.GetStudent(CurrentUser.Id);

            var answerResponse = new AnswerResponse()
            {
                Text = request.Text,
                StudentFk = student.Id,
                AnswerFk = answer.Id
            };

            UnitOfWork.AnswerResponses.Add(answerResponse);
            await UnitOfWork.SaveAsync();

            return new AnswerResponseQuestionStateDto(answerResponse.Id,
                                                      answerResponse.Uid,
                                                      answerResponse.Text,
                                                      answerResponse.CreatedOn,
                                                      new AnswerResponseStudentQuestionStateDto(student.Id,
                                                                                                student.Uid,
                                                                                                student.IndexNumber,
                                                                                                student.ImageUrl,
                                                                                                student.Reputation));
        }
    }
}
