﻿using FluentValidation;
using System.Collections.Generic;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public static class QuestioningFluentValidationRules
    {
        public static IRuleBuilderOptions<T, string> QuestionTitleValidate<T>(this IRuleBuilder<T, string> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(QuestioningErrorCodes.CantBeNull).MaximumLength(500).WithMessage(QuestioningErrorCodes.QuestionTitleLengthInvalid);
        }

        public static IRuleBuilderOptions<T, string> QuestionTextValidate<T>(this IRuleBuilder<T, string> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(QuestioningErrorCodes.CantBeNull).MaximumLength(4000).WithMessage(QuestioningErrorCodes.QuestionTextLengthInvalid);
        }

        public static IRuleBuilderOptions<T, string> AnswerResponseTextValidate<T>(this IRuleBuilder<T, string> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(QuestioningErrorCodes.CantBeNull).MaximumLength(4000).WithMessage(QuestioningErrorCodes.AnswerResponseTextLengthInvalid);
        }

        public static IRuleBuilderOptions<T, string> AnswerTextValidate<T>(this IRuleBuilder<T, string> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(QuestioningErrorCodes.CantBeNull).MaximumLength(4000).WithMessage(QuestioningErrorCodes.AnswerTextLengthInvalid);
        }

        public static IRuleBuilderOptions<T, IEnumerable<U>> ListNotNull<T, U>(this IRuleBuilder<T, IEnumerable<U>> ruleBuilder)
        {
            return ruleBuilder.NotNull().WithMessage(QuestioningErrorCodes.CantBeNull);
        }
    }
}
