import { Injectable } from '@angular/core';
import { MatDialog, MatDialogRef } from '@angular/material/dialog';
import { Observable } from 'rxjs';
import { RespondToAnswerDialogComponent } from '../components/question/respond-to-answer-dialog/respond-to-answer-dialog.component';

@Injectable({
  providedIn: 'root'
})
export class SharedDialogService {
  constructor(private dialog: MatDialog) {}

  public respondToAnswer(questionUid: string, answerUid: string): Observable<any> {
    let dialogRef: MatDialogRef<RespondToAnswerDialogComponent>;
    dialogRef = this.dialog.open(RespondToAnswerDialogComponent, {
      width: '650px',
      height: 'auto'
    });

    dialogRef.componentInstance.questionUid = questionUid;
    dialogRef.componentInstance.answerUid = answerUid;

    return dialogRef.afterClosed();
  }
}
