﻿#nullable enable

using FinkiChattery.Contracts.Questioning;
using FinkiChattery.Persistence.Repositories.Contracts;
using System.Collections.Generic;
using System.Linq;

namespace FinkiChattery.Api.ApplicationServices.Questioning
{
    public static class QuestionMapper
    {
        public static List<PreviewQuestionResponse> ToPreviewQuestionsResponse(this IEnumerable<QuestionPreviewDto> questions)
        {
            var questionsResponse = new List<PreviewQuestionResponse>();

            if (questions.Any())
            {
                questionsResponse = questions.Select(x =>
                {
                    var questionCategoriesResponse = new List<PreviewQuestionCategoryResponse>();

                    if (x.Categories.Any())
                    {
                        questionCategoriesResponse = x.Categories.Select(y => new PreviewQuestionCategoryResponse(y.Id, y.Uid, y.Text)).ToList();
                    }

                    return new PreviewQuestionResponse(x.Id, x.Uid, x.Title, x.Views, x.AnswersCount, x.CreatedOn, questionCategoriesResponse);
                }).ToList();
            }

            return questionsResponse;
        }

        public static QuestionStateResponse ToQuestionStateResponse(this QuestionStateDto questionState)
        {
            IEnumerable<AnswerQuestionStateResponse> answers = Enumerable.Empty<AnswerQuestionStateResponse>();

            if (questionState.AnswersDto.Any())
            {
                answers = questionState.AnswersDto.Select(x =>
                {
                    IEnumerable<AnswerResponseQuestionStateResponse> answerResponses = Enumerable.Empty<AnswerResponseQuestionStateResponse>();

                    if (x.AnswerResponsesDto.Any())
                    {
                        answerResponses = x.AnswerResponsesDto.Select(y =>
                        {
                            var answerResponseStudent = new AnswerResponseStudentQuestionStateResponse(y.StudentDto.Id, y.StudentDto.Uid, y.StudentDto.Index, y.StudentDto.ImageUrl, y.StudentDto.Reputation);

                            return ToAnswerResponseQuestionStateResponse(y);
                        });
                    }

                    var answerStudent = new AnswerStudentQuestionStateResponse(x.StudentDto.Id, x.StudentDto.Uid, x.StudentDto.Index, x.StudentDto.ImageUrl, x.StudentDto.Reputation);

                    return new AnswerQuestionStateResponse(x.Id, x.Uid, x.Text, x.CorrectAnswer, x.CreatedOn, x.VotesCount, answerStudent, answerResponses);
                });
            }

            IEnumerable<QuestionCategoryQuestionStateResponse> questionCategories = Enumerable.Empty<QuestionCategoryQuestionStateResponse>();

            if (questionState.CategoriesDto.Any())
            {
                questionCategories = questionState.CategoriesDto.Select(x => new QuestionCategoryQuestionStateResponse(x.Id, x.Uid, x.Name));
            }

            TeamQuestionStateResponse? team = null;

            if (questionState.TeamDto != null)
            {
                team = new TeamQuestionStateResponse(questionState.TeamDto.Id, questionState.TeamDto.Uid, questionState.TeamDto.Name);
            }

            var student = new StudentQuestionStateResponse(questionState.StudentDto.Id, questionState.StudentDto.Uid, questionState.StudentDto.Index, questionState.StudentDto.ImageUrl, questionState.StudentDto.Reputation);

            return new QuestionStateResponse(questionState.Id, questionState.Uid, questionState.Title, questionState.Text, questionState.CreatedOn, questionState.Views, questionState.LastActiveOn, student, answers, questionCategories, team);
        }

        public static AnswerResponseQuestionStateResponse ToAnswerResponseQuestionStateResponse(this AnswerResponseQuestionStateDto dto)
        {
            var answerResponseStudent = new AnswerResponseStudentQuestionStateResponse(dto.StudentDto.Id, dto.StudentDto.Uid, dto.StudentDto.Index, dto.StudentDto.ImageUrl, dto.StudentDto.Reputation);

            return new AnswerResponseQuestionStateResponse(dto.Id, dto.Uid, dto.Text, dto.CreatedOn, answerResponseStudent);
        }
    }
}
