﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class RespondToAnswerValidator : AbstractValidator<RespondToAnswerCommand>
    {
        public RespondToAnswerValidator(IUnitOfWork unitOfWork)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x.Text).AnswerResponseTextValidate();
            RuleFor(x => new AnswerInQuestionWithUidExistsDto(x.QuestionUid, x.AnswerUid)).SetValidator(new AnswerInQuestionWithUidExists(unitOfWork));
        }
    }
}
