﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class UpdateQuestionAnswersCountAndLastActivityEventHandler : IEventHandler<QuestionAnsweredEvent>
    {
        public UpdateQuestionAnswersCountAndLastActivityEventHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(QuestionAnsweredEvent notification, CancellationToken cancellationToken)
        {
            var question = await UnitOfWork.Questions.GetByUidAsync(notification.QuestionUid);

            if (question == null)
            {
                return;
            }

            question.AnswersCount++;
            question.LastActiveOn = DateTime.UtcNow;

            await UnitOfWork.SaveAsync();
        }
    }
}
