﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Helpers;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class UpdateStudentReputationEventHandler : IEventHandler<AnswerVotedEvent>
    {
        public UpdateStudentReputationEventHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(AnswerVotedEvent notification, CancellationToken cancellationToken)
        {
            var student = await UnitOfWork.Students.GetByUidAsync(notification.StudentUid);

            if (student == null)
            {
                return;
            }

            switch (notification.VoteType)
            {
                case VoteType.Upvote:
                    student.Reputation++;
                    break;
                case VoteType.Downvote:
                    student.Reputation--;
                    break;
            }

            await UnitOfWork.SaveAsync();
        }
    }
}
