﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Contracts.Questioning;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/questions/{questionUid:Guid}/[controller]/")]
    [ApiController]
    public class AnswersController : ControllerBase
    {
        public AnswersController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpPost]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> AnswerQuestion([FromRoute] Guid questionUid, [FromBody] AnswerQuestionRequest request)
        {
            var answerUid = await MediatorService.SendAsync(new AnswerQuestionCommand(questionUid, request.Text));
            return Ok(answerUid);
        }

        [HttpPut("{answerUid:Guid}/correct")]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> MarkAnswerCorrect([FromRoute] Guid questionUid, [FromRoute] Guid answerUid)
        {
            await MediatorService.SendAsync(new MarkAnswerCorrectCommand(questionUid, answerUid));
            return Ok(answerUid);
        }
    }
}
