﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class MarkAnswerCorrectValidator : AbstractValidator<MarkAnswerCorrectCommand>
    {
        public MarkAnswerCorrectValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x.QuestionUid).SetValidator(new StudentIsOwnerOfQuestion(unitOfWork, currentUser));
            RuleFor(x => new AnswerInQuestionWithUidExistsDto(x.QuestionUid, x.AnswerUid)).SetValidator(new AnswerInQuestionWithUidExists(unitOfWork));
            RuleFor(x => x.AnswerUid).SetValidator(new AnswerIsNotAlreadyMarkedAsCorrect(unitOfWork));
        }
    }
}
