﻿using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class QuestionWithUidsExist : AsyncValidatorBase
    {
        public QuestionWithUidsExist(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var questionUid = (Guid)context.PropertyValue;

            return (await UnitOfWork.Questions.GetByUidAsync(questionUid)) != null;
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.QuestionNotFound;
        }
    }
}
