﻿using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public interface IQuestionRepo : IRepository<Question>
    {
        Task<List<QuestionPreviewDto>> SearchQuestions(string searchText, IEnumerable<Guid> categories);

        Task<QuestionStateDto> GetQuestionState(Guid questionUid);

        Task<List<QuestionPreviewDto>> GetPreviewQuestionsLatest();
     
        Task<List<QuestionPreviewDto>> GetPreviewQuestionsPopular();

        Task<bool> QuestionIsOwnedByStudent(Guid questionUid, long applicationUserId);

        Task<Question> GetQuestionWithAnswersAndStudents(Guid questionUid);
    }
}
