﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class TeacherRepo : Repository<Teacher>, ITeacherRepo
    {
        public TeacherRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<TeacherSelfDto> GetTeacherSelfDto(long applicationUserId)
        {
            return await DbSet
                .AsNoTracking()
                .Include(x => x.TeacherTeams).ThenInclude(x => x.Team)
                .Where(x => x.ApplicationUserFk == applicationUserId)
                .Select(x => new TeacherSelfDto(x.Uid, x.ApplicationUserFk, x.TeacherTeams.Select(y => new TeacherTeamDto(y.Team.Uid, y.Team.Name))))
                .FirstOrDefaultAsync();
        }
    }
}
