﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Queries.User
{
    public class GetSelfUserQuery : IQuery<SelfUserDto>
    {
        public GetSelfUserQuery()
        {
        }
    }

    public class GetSelfUserQueryHandler : IQueryHandler<GetSelfUserQuery, SelfUserDto>
    {
        public GetSelfUserQueryHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<SelfUserDto> Handle(GetSelfUserQuery request, CancellationToken cancellationToken)
        {
            switch (CurrentUser.Role)
            {
                case UserRole.Student:
                    var student = await UnitOfWork.Students.GetStudentSelfDto(CurrentUser.Id);
                    return new SelfUserDto(student);
                case UserRole.Teacher:
                    var teacher = await UnitOfWork.Teachers.GetTeacherSelfDto(CurrentUser.Id);
                    return new SelfUserDto(null, teacher);
                case UserRole.Moderator:
                    var moderator = await UnitOfWork.Moderators.GetModeratorSelfDto(CurrentUser.Id);
                    return new SelfUserDto(null, null, moderator);
                case UserRole.Guest:
                default:
                    return null;
            }
        }
    }
}
