import { HttpErrorResponse } from '@angular/common/http';
import { Action } from '@ngrx/store';

import { QuestionStateViewModel } from 'src/app/shared-app/models';

export enum QuestionActionTypes {
  GetQuestionState = '[Question] Get state',
  GetQuestionStateSuccess = '[Question] Get state success',
  EffectStartedWorking = '[Question] Effect Started Working',
  EffectFinishedWorking = '[Question] Effect Finished Working',
  EffectFinishedWorkingError = '[Question] Effect Finished Working error'
}

export class GetQuestionState implements Action {
  readonly type = QuestionActionTypes.GetQuestionState;

  constructor(public questionUid: string) {}
}

export class GetQuestionStateSuccess implements Action {
  readonly type = QuestionActionTypes.GetQuestionStateSuccess;

  constructor(public payload: QuestionStateViewModel) {}
}

export class EffectStartedWorking implements Action {
  readonly type = QuestionActionTypes.EffectStartedWorking;

  constructor() {}
}

export class EffectFinishedWorking implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorking;

  constructor() {}
}

export class EffectFinishedWorkingError implements Action {
  readonly type = QuestionActionTypes.EffectFinishedWorkingError;

  constructor(public payload: HttpErrorResponse) {}
}

export type QuestionAction = GetQuestionStateSuccess | EffectStartedWorking | EffectFinishedWorking | EffectFinishedWorkingError;
