import { HttpClientModule, HTTP_INTERCEPTORS } from '@angular/common/http';
import { NgModule } from '@angular/core';
import { RouterModule } from '@angular/router';
import { StoreModule } from '@ngrx/store';
import { StoreDevtoolsModule } from '@ngrx/store-devtools';

import { environment } from '@env/environment';
import { SharedAppModule } from '../shared-app/shared-app.module';
import { SharedMaterialModule } from '../shared-material/shared-material.module';
import { COMPONENTS } from './components/components';
import { GUARDS } from './guards/guards';
import { LoaderInterceptor } from './interceptors/loader.interceptor';
import { SERVICES } from './services/services';
import { reducers } from './state';
import { TokenInterceptor } from './interceptors/token.interceptor';
import { EffectsModule } from '@ngrx/effects';
import { QuestionEffects } from './state/question-state/question.effects';

@NgModule({
  declarations: [COMPONENTS],
  providers: [
    SERVICES,
    GUARDS,
    { provide: HTTP_INTERCEPTORS, useClass: LoaderInterceptor, multi: true },
    { provide: HTTP_INTERCEPTORS, useClass: TokenInterceptor, multi: true }
  ],
  imports: [
    SharedAppModule,
    HttpClientModule,
    SharedMaterialModule,
    RouterModule,
    StoreModule.forRoot(reducers),
    StoreDevtoolsModule.instrument({
      name: 'finki-chattery App DevTools',
      maxAge: 25,
      logOnly: !environment.production
    }),
    EffectsModule.forRoot([QuestionEffects])
  ],
  exports: [HttpClientModule, COMPONENTS]
})
export class CoreModule {}
