import { QuestionAction, QuestionActionTypes } from './question.actions';
import { initialState, QuestionState } from './question.state';

export function reducer(state = initialState, action: QuestionAction): QuestionState {
  switch (action.type) {
    case QuestionActionTypes.GetQuestionStateSuccess:
      return {
        ...state,
        question: action.payload
      };
    case QuestionActionTypes.EffectStartedWorking: {
      return {
        ...state,
        effectWorking: true
      };
    }

    case QuestionActionTypes.EffectFinishedWorking: {
      return {
        ...state,
        effectWorking: false
      };
    }

    case QuestionActionTypes.EffectFinishedWorkingError: {
      return {
        ...state,
        effectWorking: action.payload
      };
    }

    default: {
      return {
        ...state
      };
    }
  }
}
