﻿using FinkiChattery.Contracts.Questioning;
using FinkiChattery.Persistence.Models;
using System.Collections.Generic;
using System.Linq;

namespace FinkiChattery.Api.ApplicationServices.Questioning
{
    public static class CategoryMapper
    {
        public static List<CategoryResponse> ToCategoryDtos(this IEnumerable<Category> categories)
        {
            var categoryDtos = new List<CategoryResponse>();

            if (categories.Any())
            {
                categoryDtos = categories.Select(x => new CategoryResponse(x.Uid, x.Name)).ToList();
            }

            return categoryDtos;
        }
    }
}
