﻿BEGIN
    SET IDENTITY_INSERT [dbo].[Question] ON
    MERGE [dbo].[Question] AS T
    USING
    (
        SELECT *
        FROM
    (
        VALUES
            (1, N'aee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Question 1', 'Question 1 text', 1, GETUTCDATE(), NULL, 0,
             GETUTCDATE(), 2
            ),
            (2, N'bee193c3-9d36-4ed8-81b2-15eb4ff305f1', N'Question 2', 'Question 2 text', 1, GETUTCDATE(), NULL, 0,
             GETUTCDATE(), 2
            )
    ) AS temp ([ID], [Uid], [Title], [Text], [StudentFk], [CreatedOn], [TeamFk], [Views], [LastActiveOn], [AnswersCount])
    ) AS S
    ON T.[ID] = S.[ID]
    WHEN MATCHED THEN
        UPDATE SET T.[Uid] = S.[Uid],
                   T.[Title] = S.[Title],
                   T.[Text] = S.[Text],
                   T.[StudentFk] = S.[StudentFk],
                   T.[CreatedOn] = S.[CreatedOn],
                   T.[TeamFk] = S.[TeamFk],
                   T.[Views] = S.[Views],
                   T.[LastActiveOn] = S.[LastActiveOn],
                   T.[AnswersCount] = S.[AnswersCount]
    WHEN NOT MATCHED THEN
        INSERT
        (
            [ID],
            [Uid],
            [Title],
            [Text],
            [StudentFk],
            [CreatedOn],
            [TeamFk],
            [Views],
            [LastActiveOn],
            [AnswersCount]
        )
        VALUES
        (S.[ID], S.[Uid], S.[Title], S.[Text], S.[StudentFk], S.[CreatedOn], S.[TeamFk], S.[Views], S.[LastActiveOn], S.[AnswersCount]);
    SET IDENTITY_INSERT [dbo].[Question] OFF
END