﻿using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace FinkiChattery.Persistence.Configurations
{
    public class QuestionConfig : BaseConfig<Question>
    {
        public QuestionConfig(string schema) : base(schema)
        {
        }

        public override void Configure(EntityTypeBuilder<Question> builder)
        {
            base.Configure(builder);

            builder.ToTable("Question", Schema);

            builder.Property(x => x.Title).HasColumnName(@"Title").HasColumnType("nvarchar").IsRequired().HasMaxLength(500);
            builder.Property(x => x.Text).HasColumnName(@"Text").HasColumnType("nvarchar").IsRequired().HasMaxLength(4000);
            builder.Property(x => x.StudentFk).HasColumnName(@"StudentFk").HasColumnType("bigint").IsRequired();
            builder.Property(x => x.CreatedOn).HasColumnName(@"CreatedOn").HasColumnType("smalldatetime").IsRequired();
            builder.Property(x => x.TeamFk).HasColumnName(@"TeamFk").HasColumnType("bigint").IsRequired(false);
            builder.Property(x => x.Views).HasColumnName(@"Views").HasColumnType("bigint").IsRequired().HasDefaultValue(0);
            builder.Property(x => x.LastActiveOn).HasColumnName(@"LastActiveOn").HasColumnType("smalldatetime").IsRequired();
            builder.Property(x => x.Search).HasColumnType(@"Search").HasColumnType("nvarchar").HasMaxLength(4000).IsRequired();
            builder.Property(x => x.AnswersCount).HasColumnType(@"AnswersCount").HasColumnType("bigint").IsRequired().HasDefaultValue(0);

            builder.HasOne(x => x.Student).WithMany(x => x.Questions).HasForeignKey(x => x.StudentFk).OnDelete(DeleteBehavior.NoAction);
            builder.HasOne(x => x.Team).WithMany(x => x.Questions).HasForeignKey(x => x.TeamFk).OnDelete(DeleteBehavior.NoAction);
        }
    }
}
