﻿using System;
using System.Collections.Generic;

namespace FinkiChattery.Persistence.Models
{
    public class Question : BaseEntity
    {
        public Question() : base()
        {
            CreatedOn = DateTime.UtcNow;
            LastActiveOn = DateTime.UtcNow;
            Answers = new List<Answer>();
            QuestionCategories = new List<QuestionCategory>();
        }

        public string Title { get; set; }

        public string Text { get; set; }

        public long StudentFk { get; set; }

        public virtual Student Student { get; set; }

        public DateTime CreatedOn { get; set; }

        public long? TeamFk { get; set; }

        public virtual Team Team { get; set; }

        public long Views { get; set; }

        public DateTime LastActiveOn { get; set; }

        public string Search { get; set; }

        public long AnswersCount { get; set; }

        public virtual ICollection<Answer> Answers { get; set; }

        public virtual ICollection<QuestionCategory> QuestionCategories { get; set; }
    }
}
