﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Repositories.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Queries.Questioning
{
    public class GetPreviewQuestionsQuery : IQuery<List<QuestionPreviewDto>>
    {
        public GetPreviewQuestionsQuery(GetPreviewQuestionsOrderEnum previewQuestionsOrder)
        {
            PreviewQuestionsOrder = previewQuestionsOrder;
        }

        public GetPreviewQuestionsOrderEnum PreviewQuestionsOrder { get; }
    }

    public class GetPreviewQuestionsHandler : IQueryHandler<GetPreviewQuestionsQuery, List<QuestionPreviewDto>>
    {
        public GetPreviewQuestionsHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task<List<QuestionPreviewDto>> Handle(GetPreviewQuestionsQuery request, CancellationToken cancellationToken)
        {
            return request.PreviewQuestionsOrder switch
            {
                GetPreviewQuestionsOrderEnum.Latest => await UnitOfWork.Questions.GetPreviewQuestionsLatest(),
                GetPreviewQuestionsOrderEnum.Popular => await UnitOfWork.Questions.GetPreviewQuestionsPopular(),
                _ => await UnitOfWork.Questions.GetPreviewQuestionsLatest(),
            };
        }
    }
}
