export class QuestionStateResponse {
  public uid!: string;
  public title!: string;
  public text!: string;
  public createdOn!: moment.Moment;
  public views!: number;
  public lastActiveOn!: moment.Moment;
  public studentResponse!: StudentQuestionStateResponse;
  public answersResponse!: AnswerQuestionStateResponse[];
  public categoriesResponse!: QuestionCategoryQuestionStateResponse[];
  public teamResponse!: TeamQuestionStateResponse | null;
}

export class StudentQuestionStateResponse {
  public uid!: string;
  public index!: string;
  public imageUrl!: string;
  public reputation!: number;
}

export class TeamQuestionStateResponse {
  public uid!: string;
  public name!: string;
}

export class QuestionCategoryQuestionStateResponse {
  public uid!: string;
  public name!: string;
}

export class AnswerQuestionStateResponse {
  public uid!: string;
  public text!: string;
  public correctAnswer!: boolean;
  public createdOn!: moment.Moment;
  public upvotesCount!: number;
  public studentResponse!: AnswerStudentQuestionStateResponse;
  public answerResponsesResponse!: AnswerResponseQuestionStateResponse[];
}

export class AnswerStudentQuestionStateResponse {
  public uid!: string;
  public index!: string;
  public imageUrl!: string;
  public reputation!: number;
}

export class AnswerResponseQuestionStateResponse {
  public uid!: string;
  public text!: string;
  public createdOn!: moment.Moment;
  public studentResponse!: AnswerResponseStudentQuestionStateResponse;
}

export class AnswerResponseStudentQuestionStateResponse {
  public uid!: string;
  public index!: string;
  public imageUrl!: string;
  public reputation!: number;
}

export class PreviewQuestionResponse {
  public uid!: string;
  public title!: string;
  public createdOn!: moment.Moment;
  public views!: number;
  public answersCount!: number;
  public categories!: PreviewQuestionCategoryResponse[];
}

export class PreviewQuestionCategoryResponse {
  public uid!: string;
  public text!: string;
}
