import { createFeatureSelector, createSelector } from '@ngrx/store';
import { QuestionState, questionStateKey } from './question.state';

export const getQuestionState = createFeatureSelector<QuestionState>(questionStateKey);

const getQuestion = createSelector(getQuestionState, (state) => state.question);
const getPreviewQuestionsLatest = createSelector(getQuestionState, (state) => state.previewQuestionsLatest);
const getPreviewQuestionsPopular = createSelector(getQuestionState, (state) => state.previewQuestionsPopular);
const effectWorking = createSelector(getQuestionState, (state) => state.effectWorking);

export const questionStateQuery = {
  effectWorking,
  getQuestion,
  getPreviewQuestionsLatest,
  getPreviewQuestionsPopular
};
