﻿using FinkiChattery.Contracts.Base;
using System;
using System.Collections.Generic;

namespace FinkiChattery.Contracts.Questioning
{
    public class PreviewQuestionResponse : Response
    {
        public PreviewQuestionResponse(long id, Guid uid, string title, long views, long answersCount, DateTime createdOn, IEnumerable<PreviewQuestionCategoryResponse> categories) : base(id, uid)
        {
            Title = title;
            Views = views;
            AnswersCount = answersCount;
            CreatedOn = createdOn;
            Categories = categories;
        }

        public string Title { get; }
        public long Views { get; }
        public long AnswersCount { get; }
        public DateTime CreatedOn { get; }
        public IEnumerable<PreviewQuestionCategoryResponse> Categories { get; }
    }

    public class PreviewQuestionCategoryResponse : Response
    {
        public PreviewQuestionCategoryResponse(long id, Guid uid, string text) : base(id, uid)
        {
            Text = text;
        }

        public string Text { get; }
    }
}
