﻿CREATE TABLE [dbo].[Question] (
    [Id]           BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]          UNIQUEIDENTIFIER NOT NULL,
    [Title]        NVARCHAR (500)   NOT NULL,
    [Text]         NVARCHAR (MAX)   NULL,
    [StudentFk]    BIGINT           NOT NULL,
    [CreatedOn]    SMALLDATETIME    NOT NULL,
    [TeamFk]       BIGINT           NULL,
    [Views]        BIGINT           DEFAULT (CONVERT([bigint],(0))) NOT NULL,
    [LastActiveOn] SMALLDATETIME    NOT NULL,
    [Search]       AS ([Title] + ' ' + [Text]), 
    [AnswersCount] BIGINT           NOT NULL DEFAULT 0, 
    CONSTRAINT [PK_Question] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_Question_Student_StudentFk] FOREIGN KEY ([StudentFk]) REFERENCES [dbo].[Student] ([Id]),
    CONSTRAINT [FK_Question_Team_TeamFk] FOREIGN KEY ([TeamFk]) REFERENCES [dbo].[Team] ([Id])
);


GO
CREATE NONCLUSTERED INDEX [IX_Question_StudentFk]
    ON [dbo].[Question]([StudentFk] ASC);


GO
CREATE NONCLUSTERED INDEX [IX_Question_TeamFk]
    ON [dbo].[Question]([TeamFk] ASC);

