﻿using System;
using System.Collections.Generic;

namespace FinkiChattery.Persistence.Repositories.Contracts
{
    public class QuestionPreviewDto
    {
        public QuestionPreviewDto(long id, Guid uid, string title, long views, long answersCount, DateTime createdOn, IEnumerable<QuestionPreviewCategoryDto> categories)
        {
            Id = id;
            Uid = uid;
            Title = title;
            Views = views;
            AnswersCount = answersCount;
            CreatedOn = createdOn;
            Categories = categories;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Title { get; }
        public long Views { get; }
        public long AnswersCount { get; }
        public DateTime CreatedOn { get; }
        public IEnumerable<QuestionPreviewCategoryDto> Categories { get; }
    }

    public class QuestionPreviewCategoryDto
    {
        public QuestionPreviewCategoryDto(long id, Guid uid, string text)
        {
            Id = id;
            Uid = uid;
            Text = text;
        }

        public long Id { get; }
        public Guid Uid { get; }
        public string Text { get; }
    }
}
