﻿using FinkiChattery.Common.User;
using Microsoft.AspNetCore.Authorization;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Authentication
{
    public class CurrentUserIsOfRoleRequirementHandler : AuthorizationHandler<CurrentUserIsOfRoleRequirement>
    {
        public CurrentUserIsOfRoleRequirementHandler(ICurrentUser currentUser)
        {
            CurrentUser = currentUser;
        }

        public ICurrentUser CurrentUser { get; }

        protected override Task HandleRequirementAsync(AuthorizationHandlerContext context, CurrentUserIsOfRoleRequirement requirement)
        {
            if (CurrentUser.Role != requirement.UserRole)
            {
                context.Fail();
            }

            context.Succeed(requirement);
            return Task.CompletedTask;
        }
    }
}
