﻿using FinkiChattery.Persistence.Repositories;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class TeamWithUidExist : AsyncValidatorBase
    {
        public TeamWithUidExist(ITeamRepo teamRepo)
        {
            TeamRepo = teamRepo;
        }

        public ITeamRepo TeamRepo { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var teamUid = (Guid)context.PropertyValue;
            return await TeamRepo.TeamWithUidExists(teamUid);        
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.TeamDontExist;
        }
    }
}
