﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class CategoriesRepo : Repository<Category>, ICategoriesRepo
    {
        public CategoriesRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<bool> CategoriesExist(IEnumerable<Guid> categoriesUids)
        {
            return await DbSet.Where(x => categoriesUids.Contains(x.Uid)).CountAsync() == categoriesUids.Count();
        }

        public async Task<IEnumerable<Category>> GetCategories(IEnumerable<Guid> categoriesUids)
        {
            return await DbSet.Where(x => categoriesUids.Contains(x.Uid)).ToListAsync();
        }
    }
}
