﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class AskQuestionCommand : ICommand<Guid>
    {
        public AskQuestionCommand(string title, string text, IEnumerable<Guid> categories)
        {
            Title = title;
            Text = text;
            Categories = categories;
        }

        public string Title { get; }
        public string Text { get; }
        public IEnumerable<Guid> Categories { get; }
    }

    public class AskQuestionHandler : ICommandHandler<AskQuestionCommand, Guid>
    {
        public AskQuestionHandler(ApplicationDbContext dbContext, ICategoriesRepo categoriesRepo, IStudentRepo studentRepo, ICurrentUser currentUser)
        {
            DbContext = dbContext;
            CategoriesRepo = categoriesRepo;
            StudentRepo = studentRepo;
            CurrentUser = currentUser;
        }

        public ApplicationDbContext DbContext { get; }
        public ICategoriesRepo CategoriesRepo { get; }
        public IStudentRepo StudentRepo { get; }
        public ICurrentUser CurrentUser { get; }

        public async Task<Guid> Handle(AskQuestionCommand request, CancellationToken cancellationToken)
        {
            var questionCategories = await CategoriesRepo.GetCategories(request.Categories);
            var currentStudent = await StudentRepo.GetStudent(CurrentUser.Id);

            var questionDatabaseEntity = new Question()
            {
                Title = request.Title,
                Text = request.Text,
                StudentFk = currentStudent.Id,
            };

            foreach (var item in questionCategories)
            {
                questionDatabaseEntity.QuestionCategories.Add(new QuestionCategory()
                {
                    CategoryFk = item.Id
                });
            }

            DbContext.Questions.Add(questionDatabaseEntity);
            await DbContext.SaveChangesAsync();
            return questionDatabaseEntity.Uid;
        }
    }
}
