﻿using FinkiChattery.Persistence.Repositories;
using FluentValidation.Validators;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class CategoriesUidsExist : AsyncValidatorBase
    {
        public CategoriesUidsExist(ICategoriesRepo categoriesRepo)
        {
            CategoriesRepo = categoriesRepo;
        }

        public ICategoriesRepo CategoriesRepo { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var categoriesUids = (IEnumerable<Guid>)context.PropertyValue;

            return await CategoriesRepo.CategoriesExist(categoriesUids);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.CategoriesDontExist;
        }
    }
}
