﻿CREATE TABLE [dbo].[Student] (
    [Id]                BIGINT           IDENTITY (1, 1) NOT NULL,
    [Uid]               UNIQUEIDENTIFIER NOT NULL,
    [ApplicationUserFk] BIGINT           NOT NULL,
    [IndexNumber]       NVARCHAR (50)     NOT NULL,
    [Reputation]        BIGINT           DEFAULT (CONVERT([bigint],(0))) NOT NULL,
    [ReportReputation]  BIGINT           DEFAULT (CONVERT([bigint],(0))) NOT NULL,
    [ImageUrl]          NVARCHAR (1000)     NOT NULL,
    CONSTRAINT [PK_Student] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_Student_AspNetUsers_ApplicationUserFk] FOREIGN KEY ([ApplicationUserFk]) REFERENCES [dbo].[AspNetUsers] ([Id])
);


GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_Student_ApplicationUserFk]
    ON [dbo].[Student]([ApplicationUserFk] ASC);

