﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class StudentRepo : Repository<Student>, IStudentRepo
    {
        public StudentRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<Student> GetStudent(long applicationUserFk)
        {
            return await DbSet.FirstOrDefaultAsync(x => x.ApplicationUserFk == applicationUserFk);
        }
    }
}
