﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class TeamRepo : Repository<Team>, ITeamRepo
    {
        public TeamRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<bool> TeamWithUidExists(Guid teamUid)
        {
            return await DbSet.AnyAsync(x => x.Uid == teamUid);
        }
    }
}
