import { Component, OnInit } from '@angular/core';
import { FormControl, Validators } from '@angular/forms';

import { CategoryFacadeService } from 'src/app/core/state/category-facade.service';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-search-question',
  templateUrl: './search-question.component.html',
  styleUrls: ['./search-question.component.scss']
})
export class SearchQuestionComponent implements OnInit {
  ButtonType = ButtonType;
  questionSearchFormContor = new FormControl('', [Validators.required, Validators.maxLength(250)]);
  questionCategoriesFormContor = new FormControl();
  categories$ = this.categoriesFacade.getCategories();
  isExpanded = false;

  constructor(private categoriesFacade: CategoryFacadeService, private questionsFacade: QuestionFacadeService) {}

  ngOnInit(): void {}

  public searchQuestions(): void {
    this.isExpanded = false;
    this.questionsFacade.searchQuestions(this.questionSearchFormContor.value, this.questionCategoriesFormContor.value);
    this.questionSearchFormContor.reset();
    this.questionCategoriesFormContor.reset();
  }
}
