import { Injectable } from '@angular/core';
import { CanActivate, ActivatedRouteSnapshot, RouterStateSnapshot, UrlTree } from '@angular/router';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';
import { ApplicationUserType } from 'src/app/shared-app/models';
import { AuthService } from '../services';

@Injectable({
  providedIn: 'root'
})
export class AuthorizedStudentGuard implements CanActivate {
  constructor(private auth: AuthService) {}

  canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot): Observable<boolean> {
    return this.auth.currentUser().pipe(
      map((user) => {
        if (user?.userType === ApplicationUserType.Student) {
          return true;
        }
        this.auth.login();
        return false;
      })
    );
  }
}
