import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { NotificationService } from 'src/app/core/services/notification.service';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';

import { QuestionStateViewModel, VoteType } from 'src/app/shared-app/models';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-question-preview',
  templateUrl: './question-preview.component.html',
  styleUrls: ['./question-preview.component.scss']
})
export class QuestionPreviewComponent implements OnInit {
  question!: QuestionStateViewModel;
  working = true;
  ButtonType = ButtonType;
  constructor(private questionFacade: QuestionFacadeService, private notification: NotificationService) {}

  ngOnInit(): void {
    this.questionFacade.getQuestion().subscribe((question) => {
      this.question = question;
      this.working = false;
    });

    this.questionFacade.effectWorking$.subscribe((effect) => {
      if (effect instanceof HttpErrorResponse) {
        this.notification.handleErrorsNotification(effect.error);
      }
    });
  }

  answerVoted(voteType: VoteType, answerUid: string, questionUid: string): void {
    this.questionFacade.voteAnswer(answerUid, questionUid, voteType);
  }
}
