﻿using FinkiChattery.Commands.Questioning.Validators;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation;

namespace FinkiChattery.Commands.Questioning
{
    public class AnswerQuestionValidator : AbstractValidator<AnswerQuestionCommand>
    {
        public AnswerQuestionValidator(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            CascadeMode = CascadeMode.Stop;

            RuleFor(x => x.Text).AnswerTextValidate();
            RuleFor(x => x.QuestionUid).SetValidator(new QuestionWithUidsExist(unitOfWork));
            RuleFor(x => x).SetValidator(new StudentHasGoodReputationAndCanVoteAndAnswer(unitOfWork, currentUser));
        }
    }
}
